import { generatePageMetadata } from "@/lib/seo/metadata"
import { CreateAccountTabs } from "@/components/frontend/create-account-tabs"
import { AuthLayout } from "@/components/frontend/auth-layout"
import type { Metadata } from "next"
import Link from "next/link"

export const metadata: Metadata = generatePageMetadata({
  title: "Create Account",
  description: "Create your Teertham account - Customer or Agent",
  path: "/create-account",
  noIndex: true,
})

export default function CreateAccountPage() {
  return (
    <AuthLayout variant="create-account">
      <article className="space-y-6">
        <header className="text-center space-y-2">
          <h1 className="text-3xl font-bold text-balance">Create Account</h1>
          <p className="text-muted-foreground text-pretty">Choose your account type and fill in your details</p>
        </header>

        <section className="bg-card border rounded-xl p-6 shadow-sm space-y-6">
          <CreateAccountTabs />

          <div className="text-center pt-4 border-t">
            <p className="text-sm text-muted-foreground">
              Already have an account?{" "}
              <Link href="/login" className="text-primary hover:underline font-medium">
                Sign In
              </Link>
            </p>
          </div>
        </section>
      </article>
    </AuthLayout>
  )
}
