import { generatePageMetadata } from "@/lib/seo/metadata"
import { LoginForm } from "@/components/frontend/login-form"
import { AuthLayout } from "@/components/frontend/auth-layout"
import { DemoCredentials } from "@/components/frontend/demo-credentials"
import type { Metadata } from "next"
import Link from "next/link"

export const metadata: Metadata = generatePageMetadata({
  title: "Login",
  description: "Login to your Teertham account",
  path: "/login",
  noIndex: true,
})

export default function LoginPage() {
  return (
    <AuthLayout variant="login">
      <article className="space-y-6">
        <header className="text-center space-y-2">
          <h1 className="text-3xl font-bold text-balance">Welcome Back</h1>
          <p className="text-muted-foreground text-pretty">Sign in to your account to continue</p>
        </header>

        <section className="bg-card border rounded-xl p-6 shadow-sm space-y-6">
          <LoginForm />

          <div className="text-center space-y-3 pt-4 border-t">
            <p className="text-sm text-muted-foreground">
              Don't have an account?{" "}
              <Link href="/create-account" className="text-primary hover:underline font-medium">
                Create Account
              </Link>
            </p>
            <Link
              href="/forget-password"
              className="text-sm text-muted-foreground hover:text-primary transition-colors"
            >
              Forgot your password?
            </Link>
          </div>
        </section>

        {/* Demo credentials section */}
        <DemoCredentials />
      </article>
    </AuthLayout>
  )
}
