import type { Metadata } from "next"
import { Suspense } from "react"
import { generatePageMetadata, generateJsonLd } from "@/lib/seo/metadata"
import { LegalPageEditor } from "@/components/admin/legal/legal-page-editor"
import { Skeleton } from "@/components/ui/skeleton"

export const metadata: Metadata = generatePageMetadata({
  title: "Agent Terms",
  description: "Manage terms and conditions for travel agents on Teertham platform. Edit meta information and content.",
  path: "/admin/agent-terms",
  noIndex: true,
})

function EditorLoading() {
  return (
    <div className="space-y-6">
      <div className="space-y-2">
        <Skeleton className="h-8 w-48" />
        <Skeleton className="h-4 w-96" />
      </div>
      <Skeleton className="h-64 w-full rounded-xl" />
      <Skeleton className="h-96 w-full rounded-xl" />
    </div>
  )
}

export default function AgentTermsPage() {
  const jsonLd = generateJsonLd({
    "@type": "WebPage",
    name: "Agent Terms Management | Teertham Admin",
    description: "Administrative interface for managing agent terms and conditions.",
  })

  return (
    <>
      <script type="application/ld+json" dangerouslySetInnerHTML={jsonLd} />
      <main>
        <Suspense fallback={<EditorLoading />}>
          <LegalPageEditor
            slug="agent-terms"
            title="Agent Terms & Conditions"
            description="Manage the terms and conditions for travel agent partners."
          />
        </Suspense>
      </main>
    </>
  )
}
