import type { Metadata } from "next"
import { WithdrawalsClient } from "@/components/admin/withdrawals/withdrawals-client"

export const metadata: Metadata = {
  title: "Agent Withdraw | Teertham Admin",
  description: "Manage and process agent withdrawal requests. View pending, approved, and cancelled withdrawals.",
  openGraph: {
    title: "Agent Withdraw | Teertham Admin",
    description: "Manage and process agent withdrawal requests.",
    type: "website",
  },
}

export default function AgentWithdrawPage() {
  return (
    <WithdrawalsClient
      userType="agent"
      title="Agent Withdraw"
      description="View and manage all agent withdrawal requests"
    />
  )
}
