import type { Metadata } from "next"
import { CustomersClient } from "@/components/admin/customers/customers-client"

export const metadata: Metadata = {
  title: "Customers | Teertham",
  description:
    "Manage customer accounts, view booking history, and handle customer status. Monitor active and blocked customers on the Teertham admin panel.",
  openGraph: {
    title: "Customers | Teertham",
    description:
      "Manage customer accounts, view booking history, and handle customer status on the Teertham admin panel.",
    type: "website",
  },
  twitter: {
    card: "summary",
    title: "Customers | Teertham",
    description: "Manage customer accounts and booking history on Teertham admin panel.",
  },
}

export default function CustomersPage() {
  return (
    <main>
      <CustomersClient />
    </main>
  )
}
