import type { Metadata } from "next"
import { HotelBookingsClient } from "@/components/admin/hotel-bookings/hotel-bookings-client"

export const metadata: Metadata = {
  title: "Hotels Booking | Teertham Admin",
  description:
    "View and manage all hotel bookings on Teertham platform. Track booked, completed, and cancelled reservations.",
  robots: { index: false, follow: false },
  openGraph: {
    title: "Hotels Booking | Teertham Admin",
    description: "View and manage all hotel bookings on Teertham platform.",
    type: "website",
  },
}

export default function HotelsBookingPage() {
  return (
    <main>
      <HotelBookingsClient />
    </main>
  )
}
