import type { Metadata } from "next"
import { ManageRolesClient } from "@/components/admin/sub-admin/manage-roles-client"

export const metadata: Metadata = {
  title: "Manage Roles | Teertham",
  description:
    "Create and manage user roles with custom permissions for your team members in the Teertham admin panel.",
  openGraph: {
    title: "Manage Roles | Teertham",
    description:
      "Create and manage user roles with custom permissions for your team members in the Teertham admin panel.",
    type: "website",
  },
  twitter: {
    card: "summary",
    title: "Manage Roles | Teertham",
    description:
      "Create and manage user roles with custom permissions for your team members in the Teertham admin panel.",
  },
}

export default function ManageRolesPage() {
  return (
    <main className="space-y-6">
      <header>
        <h1 className="text-2xl font-bold tracking-tight md:text-3xl">Manage Roles</h1>
        <p className="text-muted-foreground mt-1">
          Create and configure roles with specific permissions for team members.
        </p>
      </header>
      <ManageRolesClient />
    </main>
  )
}
