import { Skeleton } from "@/components/ui/skeleton"

export default function HotelBookingLoading() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-gray-50 via-white to-gray-100 p-6">
      <Skeleton className="h-32 w-full rounded-2xl mb-8" />
      <Skeleton className="h-24 w-full rounded-xl mb-6" />
      <div className="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
        {[...Array(2)].map((_, i) => (
          <Skeleton key={i} className="h-48 rounded-xl" />
        ))}
      </div>
      <Skeleton className="h-64 rounded-xl" />
    </div>
  )
}
