import type { Metadata } from "next"
import { Suspense } from "react"
import { HotelPageWrapper } from "@/components/hotel/hotel-page-wrapper"
import { HotelSidebarNav } from "@/components/hotel/hotel-sidebar-nav"
import { WithdrawTable } from "@/components/hotel/withdraw/withdraw-table"
import { EarningSummary } from "@/components/hotel/withdraw/earning-summary"
import { WithdrawLoadingSkeleton } from "@/components/hotel/withdraw/withdraw-loading-skeleton"

export const metadata: Metadata = {
  title: "Earning & Withdraw",
  description: "Track your earnings and manage withdrawal requests",
}

interface WithdrawPageProps {
  searchParams: Promise<{ status?: string }>
}

export default async function HotelWithdrawPage({ searchParams }: WithdrawPageProps) {
  const params = await searchParams
  const status = params.status || "pending"

  return (
    <HotelPageWrapper>
      <div className="space-y-6">
        {/* Page Header */}
        <header>
          <h1 className="text-3xl font-bold tracking-tight text-foreground">Earning & Withdraw</h1>
          <p className="text-muted-foreground mt-1">Track your earnings and manage withdrawal requests</p>
        </header>

        {/* Earning Summary Section */}
        <section aria-labelledby="earnings-heading">
          <h2 id="earnings-heading" className="sr-only">
            Earnings Summary
          </h2>
          <EarningSummary />
        </section>

        {/* Main Content Layout */}
        <div className="flex flex-col lg:flex-row gap-6">
          <HotelSidebarNav type="withdraw" />
          <main className="flex-1" role="main" aria-label="Withdraw history content">
            <Suspense fallback={<WithdrawLoadingSkeleton />}>
              <WithdrawTable status={status} />
            </Suspense>
          </main>
        </div>
      </div>
    </HotelPageWrapper>
  )
}
