"use client"

import { EarningsTable } from "./earnings-table"
import { EarningsSummaryCards } from "./earnings-summary-cards"
import type { EarningRecord } from "@/lib/data/earnings"

interface EarningsClientProps {
  data: EarningRecord[]
  summary: {
    totalEarning: number
    thisMonthEarning: number
    totalWalletBalance: number
    totalWithdrawn: number
  }
  userType: "agent" | "hotel"
}

export function EarningsClient({ data, summary, userType }: EarningsClientProps) {
  return (
    <div className="space-y-6">
      <EarningsSummaryCards
        totalEarning={summary.totalEarning}
        thisMonthEarning={summary.thisMonthEarning}
        totalWalletBalance={summary.totalWalletBalance}
        totalWithdrawn={summary.totalWithdrawn}
        userType={userType}
      />
      <EarningsTable data={data} userType={userType} />
    </div>
  )
}
