"use client"

import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Plus, CalendarPlus, Settings, Download } from "lucide-react"
import Link from "next/link"

const actions = [
  {
    title: "Add Room",
    icon: Plus,
    href: "/hotel/room-settings?tab=rooms",
    color: "bg-blue-500",
  },
  {
    title: "Bookings",
    icon: CalendarPlus,
    href: "/hotel/bookings",
    color: "bg-emerald-500",
  },
  {
    title: "Report",
    icon: Download,
    href: "/hotel/withdraw",
    color: "bg-violet-500",
  },
  {
    title: "Settings",
    icon: Settings,
    href: "/hotel/room-settings?tab=hotel",
    color: "bg-slate-600",
  },
]

export function QuickActions() {
  return (
    <Card className="border bg-card">
      <CardHeader className="pb-3">
        <CardTitle className="text-lg font-semibold">Quick Actions</CardTitle>
      </CardHeader>

      <CardContent className="grid grid-cols-2 gap-2">
        {actions.map((action) => {
          const Icon = action.icon

          return (
            <Link key={action.title} href={action.href}>
              <Button
                variant="outline"
                className="w-full h-auto flex-col items-center gap-2 py-4 hover:bg-muted/50 transition-all duration-200 bg-transparent"
              >
                <div className={`p-2 rounded-lg ${action.color}`}>
                  <Icon className="h-4 w-4 text-white" />
                </div>
                <span className="font-medium text-sm">{action.title}</span>
              </Button>
            </Link>
          )
        })}
      </CardContent>
    </Card>
  )
}
