"use client"

import { Card, CardContent, CardHeader, CardTitle, CardDescription } from "@/components/ui/card"
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select"
import { TrendingUp, IndianRupee } from "lucide-react"

const monthlyData = [
  { month: "Jan", revenue: 245000, bookings: 89 },
  { month: "Feb", revenue: 298000, bookings: 102 },
  { month: "Mar", revenue: 356000, bookings: 124 },
  { month: "Apr", revenue: 412000, bookings: 138 },
  { month: "May", revenue: 389000, bookings: 131 },
  { month: "Jun", revenue: 478000, bookings: 156 },
  { month: "Jul", revenue: 534000, bookings: 172 },
  { month: "Aug", revenue: 612000, bookings: 198 },
  { month: "Sep", revenue: 567000, bookings: 184 },
  { month: "Oct", revenue: 623000, bookings: 201 },
  { month: "Nov", revenue: 698000, bookings: 225 },
  { month: "Dec", revenue: 845000, bookings: 267 },
]

const maxRevenue = Math.max(...monthlyData.map((d) => d.revenue))

export function RevenueChart() {
  return (
    <Card className="border bg-card">
      <CardHeader className="flex flex-row items-center justify-between pb-2">
        <div>
          <CardTitle className="text-lg font-semibold">Revenue Overview</CardTitle>
          <CardDescription>Monthly revenue and booking trends</CardDescription>
        </div>
        <Select defaultValue="2025">
          <SelectTrigger className="w-[100px]">
            <SelectValue placeholder="Year" />
          </SelectTrigger>
          <SelectContent>
            <SelectItem value="2025">2025</SelectItem>
            <SelectItem value="2024">2024</SelectItem>
          </SelectContent>
        </Select>
      </CardHeader>
      <CardContent>
        {/* Summary Cards */}
        <div className="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
          <div className="p-4 rounded-xl bg-emerald-50 dark:bg-emerald-950/30 border border-emerald-200 dark:border-emerald-900">
            <div className="flex items-center gap-2 text-emerald-600 dark:text-emerald-400 mb-1">
              <IndianRupee className="h-4 w-4" />
              <span className="text-xs font-medium">Total Revenue</span>
            </div>
            <p className="text-2xl font-bold text-emerald-700 dark:text-emerald-300">₹60,57,000</p>
          </div>
          <div className="p-4 rounded-xl bg-blue-50 dark:bg-blue-950/30 border border-blue-200 dark:border-blue-900">
            <div className="flex items-center gap-2 text-blue-600 dark:text-blue-400 mb-1">
              <TrendingUp className="h-4 w-4" />
              <span className="text-xs font-medium">Growth Rate</span>
            </div>
            <p className="text-2xl font-bold text-blue-700 dark:text-blue-300">+24.5%</p>
          </div>
          <div className="p-4 rounded-xl bg-violet-50 dark:bg-violet-950/30 border border-violet-200 dark:border-violet-900">
            <div className="flex items-center gap-2 text-violet-600 dark:text-violet-400 mb-1">
              <span className="text-xs font-medium">Total Bookings</span>
            </div>
            <p className="text-2xl font-bold text-violet-700 dark:text-violet-300">1,987</p>
          </div>
          <div className="p-4 rounded-xl bg-amber-50 dark:bg-amber-950/30 border border-amber-200 dark:border-amber-900">
            <div className="flex items-center gap-2 text-amber-600 dark:text-amber-400 mb-1">
              <span className="text-xs font-medium">Avg. Booking Value</span>
            </div>
            <p className="text-2xl font-bold text-amber-700 dark:text-amber-300">₹3,048</p>
          </div>
        </div>

        {/* Bar Chart */}
        <div className="h-[200px] flex items-end gap-2 pt-4">
          {monthlyData.map((data) => (
            <div key={data.month} className="flex-1 flex flex-col items-center gap-2">
              <div
                className="w-full bg-gradient-to-t from-slate-600 to-slate-400 dark:from-slate-400 dark:to-slate-300 rounded-t-md transition-all duration-300 hover:from-slate-700 hover:to-slate-500"
                style={{ height: `${(data.revenue / maxRevenue) * 160}px` }}
                title={`₹${data.revenue.toLocaleString()}`}
              />
              <span className="text-xs text-muted-foreground">{data.month}</span>
            </div>
          ))}
        </div>
      </CardContent>
    </Card>
  )
}
