"use client"

import { Card, CardContent, CardHeader, CardTitle, CardDescription } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { Label } from "@/components/ui/label"
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar"
import { User, Mail, Phone, MapPin, Camera, Save, Building2 } from "lucide-react"

export function ProfileSettings() {
  return (
    <div className="space-y-6">
      {/* Profile Photo */}
      <Card className="border bg-card">
        <CardHeader>
          <div className="flex items-center gap-3">
            <div className="p-2 rounded-lg bg-blue-500">
              <Camera className="h-5 w-5 text-white" aria-hidden="true" />
            </div>
            <div>
              <CardTitle>Profile Photo</CardTitle>
              <CardDescription>Upload your hotel manager profile picture</CardDescription>
            </div>
          </div>
        </CardHeader>
        <CardContent>
          <div className="flex items-center gap-6">
            <Avatar className="h-24 w-24 border-4 border-border">
              <AvatarImage src="/placeholder.svg?height=96&width=96" alt="Profile photo of hotel manager" />
              <AvatarFallback className="text-2xl bg-slate-100 dark:bg-slate-800">HM</AvatarFallback>
            </Avatar>
            <div className="space-y-2">
              <div className="flex gap-2">
                <Button variant="outline" size="sm" type="button">
                  <Camera className="h-4 w-4 mr-2" aria-hidden="true" />
                  Upload Photo
                </Button>
                <Button
                  variant="ghost"
                  size="sm"
                  type="button"
                  className="text-red-500 hover:text-red-600 hover:bg-red-50 dark:hover:bg-red-950"
                >
                  Remove
                </Button>
              </div>
              <p className="text-xs text-muted-foreground">Recommended: Square image, at least 200x200px. Max 5MB.</p>
            </div>
          </div>
        </CardContent>
      </Card>

      {/* Personal Information */}
      <Card className="border bg-card">
        <CardHeader>
          <div className="flex items-center gap-3">
            <div className="p-2 rounded-lg bg-emerald-500">
              <User className="h-5 w-5 text-white" aria-hidden="true" />
            </div>
            <div>
              <CardTitle>Personal Information</CardTitle>
              <CardDescription>Update your personal details</CardDescription>
            </div>
          </div>
        </CardHeader>
        <CardContent>
          <form className="space-y-4" onSubmit={(e) => e.preventDefault()}>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
              <div className="space-y-2">
                <Label htmlFor="firstName">First Name</Label>
                <Input id="firstName" name="firstName" defaultValue="Ramesh" autoComplete="given-name" />
              </div>
              <div className="space-y-2">
                <Label htmlFor="lastName">Last Name</Label>
                <Input id="lastName" name="lastName" defaultValue="Sharma" autoComplete="family-name" />
              </div>
            </div>

            <div className="space-y-2">
              <Label htmlFor="designation">Designation</Label>
              <Input
                id="designation"
                name="designation"
                defaultValue="Hotel Manager"
                autoComplete="organization-title"
              />
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
              <div className="space-y-2">
                <Label htmlFor="email" className="flex items-center gap-2">
                  <Mail className="h-4 w-4" aria-hidden="true" /> Email Address
                </Label>
                <Input
                  id="email"
                  name="email"
                  type="email"
                  defaultValue="ramesh.sharma@grandteertham.com"
                  autoComplete="email"
                />
              </div>
              <div className="space-y-2">
                <Label htmlFor="phone" className="flex items-center gap-2">
                  <Phone className="h-4 w-4" aria-hidden="true" /> Phone Number
                </Label>
                <Input id="phone" name="phone" type="tel" defaultValue="+91 98765 43210" autoComplete="tel" />
              </div>
            </div>

            <div className="space-y-2">
              <Label htmlFor="address" className="flex items-center gap-2">
                <MapPin className="h-4 w-4" aria-hidden="true" /> Address
              </Label>
              <Input
                id="address"
                name="address"
                defaultValue="123 Main Street, Varanasi, UP 221001"
                autoComplete="street-address"
              />
            </div>
          </form>
        </CardContent>
      </Card>

      {/* Hotel Association */}
      <Card className="border bg-card">
        <CardHeader>
          <div className="flex items-center gap-3">
            <div className="p-2 rounded-lg bg-violet-500">
              <Building2 className="h-5 w-5 text-white" aria-hidden="true" />
            </div>
            <div>
              <CardTitle>Hotel Association</CardTitle>
              <CardDescription>Your associated hotel details</CardDescription>
            </div>
          </div>
        </CardHeader>
        <CardContent className="space-y-4">
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="space-y-2">
              <Label htmlFor="hotelName">Hotel Name</Label>
              <Input id="hotelName" value="Grand Teertham Resort" disabled className="bg-muted" aria-readonly="true" />
            </div>
            <div className="space-y-2">
              <Label htmlFor="hotelId">Hotel ID</Label>
              <Input id="hotelId" value="HTL-2025-001" disabled className="bg-muted" aria-readonly="true" />
            </div>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="space-y-2">
              <Label htmlFor="registeredSince">Registered Since</Label>
              <Input id="registeredSince" value="January 15, 2024" disabled className="bg-muted" aria-readonly="true" />
            </div>
            <div className="space-y-2">
              <Label htmlFor="accountStatus">Account Status</Label>
              <Input
                id="accountStatus"
                value="Active"
                disabled
                className="bg-muted text-emerald-600"
                aria-readonly="true"
              />
            </div>
          </div>
        </CardContent>
      </Card>

      <div className="flex justify-end gap-3">
        <Button variant="outline" type="button">
          Cancel
        </Button>
        <Button
          type="submit"
          className="bg-slate-900 hover:bg-slate-800 dark:bg-white dark:text-slate-900 dark:hover:bg-slate-100"
        >
          <Save className="h-4 w-4 mr-2" aria-hidden="true" />
          Save Changes
        </Button>
      </div>
    </div>
  )
}
