"use client"

import { toast as sonnerToast } from "sonner"

interface ToastOptions {
  title?: string
  description?: string
  duration?: number
}

/**
 * Unified toast hook with consistent styling
 * Uses sonner under the hood for better UX
 */
export function useToastEnhanced() {
  const success = ({ title, description, duration = 3000 }: ToastOptions) => {
    sonnerToast.success(title || "Success", {
      description,
      duration,
    })
  }

  const error = ({ title, description, duration = 4000 }: ToastOptions) => {
    sonnerToast.error(title || "Error", {
      description,
      duration,
    })
  }

  const info = ({ title, description, duration = 3000 }: ToastOptions) => {
    sonnerToast.info(title || "Info", {
      description,
      duration,
    })
  }

  const warning = ({ title, description, duration = 3000 }: ToastOptions) => {
    sonnerToast.warning(title || "Warning", {
      description,
      duration,
    })
  }

  return { success, error, info, warning }
}

// Re-export for backwards compatibility
