// Pagination
export const ITEMS_PER_PAGE_OPTIONS = [10, 20, 50, 100] as const
export const DEFAULT_ITEMS_PER_PAGE = 10

// Package categories
export const PACKAGE_CATEGORIES = [
  { value: "adventure", label: "Adventure" },
  { value: "thrill", label: "Thrill" },
  { value: "suspense", label: "Suspense" },
  { value: "spiritual", label: "Spiritual" },
  { value: "others", label: "Others" },
] as const

// Status options
export const PACKAGE_STATUS_OPTIONS = [
  { value: "active", label: "Active", variant: "default" },
  { value: "inactive", label: "Inactive", variant: "secondary" },
] as const

export const BOOKING_STATUS_OPTIONS = [
  { value: "booked", label: "Booked", variant: "default" },
  { value: "ongoing", label: "Ongoing", variant: "secondary" },
  { value: "completed", label: "Completed", variant: "outline" },
  { value: "cancelled", label: "Cancelled", variant: "destructive" },
] as const

// Price limits
export const MIN_PRICE = 100
export const MAX_PRICE = 1000000
export const MIN_DISCOUNT_PERCENTAGE = 0
export const MAX_DISCOUNT_PERCENTAGE = 90

// Package limits
export const MIN_DAYS = 1
export const MAX_DAYS = 30
export const MIN_PASSENGER_LIMIT = 1
export const MAX_PASSENGER_LIMIT = 50

// Day selection limits for custom packages
export const MIN_CUSTOM_PACKAGE_DAYS = 1
export const MAX_CUSTOM_PACKAGE_DAYS = 15

// Validation limits
export const MAX_NAME_LENGTH = 100
export const MAX_DESCRIPTION_LENGTH = 2000
export const MAX_LOCATION_NAME_LENGTH = 200
export const MIN_TRAVELERS = 1
export const MAX_TRAVELERS = 100

// Payment
export const DEFAULT_ADVANCE_PERCENTAGE = 30
export const DEFAULT_AGENT_COMMISSION_PERCENTAGE = 10
export const DEFAULT_HOTEL_COMMISSION_PERCENTAGE = 15

// Date formats
export const DATE_FORMAT = "yyyy-MM-dd"
export const DISPLAY_DATE_FORMAT = "MMM dd, yyyy"
export const DISPLAY_DATETIME_FORMAT = "MMM dd, yyyy HH:mm"

// Currency
export const CURRENCY_CODE = "INR"
export const CURRENCY_SYMBOL = "₹"
export const CURRENCY_LOCALE = "en-IN"

// Image validation
export const MAX_IMAGE_SIZE = 5 * 1024 * 1024 // 5MB
export const ALLOWED_IMAGE_TYPES = ["image/jpeg", "image/jpg", "image/png", "image/webp"] as const
export const ALLOWED_IMAGE_EXTENSIONS = [".jpg", ".jpeg", ".png", ".webp"] as const

// Error messages
export const ERROR_MESSAGES = {
  REQUIRED_FIELD: "This field is required",
  INVALID_EMAIL: "Please enter a valid email address",
  INVALID_PHONE: "Please enter a valid phone number",
  INVALID_PRICE: "Please enter a valid price",
  INVALID_DATE: "Please enter a valid date",
  DUPLICATE_NAME: "This name already exists",
  MIN_PRICE: `Price must be at least ${CURRENCY_SYMBOL}${MIN_PRICE}`,
  MAX_PRICE: `Price cannot exceed ${CURRENCY_SYMBOL}${MAX_PRICE}`,
  INVALID_DISCOUNT: "Discount percentage must be between 0 and 90",
  MIN_DAYS: `Minimum ${MIN_DAYS} day required`,
  MAX_DAYS: `Maximum ${MAX_DAYS} days allowed`,
  IMAGE_TOO_LARGE: `Image size must be less than ${MAX_IMAGE_SIZE / 1024 / 1024}MB`,
  INVALID_IMAGE_TYPE: "Only JPEG, PNG, and WebP images are allowed",
} as const

// Success messages
export const SUCCESS_MESSAGES = {
  PACKAGE_CREATED: "Package created successfully",
  PACKAGE_UPDATED: "Package updated successfully",
  PACKAGE_DELETED: "Package deleted successfully",
  PACKAGE_ACTIVATED: "Package activated successfully",
  PACKAGE_DEACTIVATED: "Package deactivated successfully",
  BOOKING_CREATED: "Booking created successfully",
  BOOKING_UPDATED: "Booking updated successfully",
  BOOKING_CANCELLED: "Booking cancelled successfully",
} as const
