"use client"

const CSRF_TOKEN_NAME = "csrf_token"

/**
 * Generate a client-side CSRF token
 */
export function generateClientCsrfToken(): string {
  if (typeof window === "undefined") {
    return ""
  }

  const existingToken = sessionStorage.getItem(CSRF_TOKEN_NAME)
  if (existingToken) {
    return existingToken
  }

  const token = crypto.randomUUID()
  sessionStorage.setItem(CSRF_TOKEN_NAME, token)
  return token
}

/**
 * Verify client-side CSRF token
 */
export function verifyClientCsrfToken(token: string): boolean {
  if (typeof window === "undefined") {
    return false
  }

  const storedToken = sessionStorage.getItem(CSRF_TOKEN_NAME)
  return storedToken === token && token.length > 0
}

/**
 * Clear client-side CSRF token
 */
export function clearClientCsrfToken(): void {
  if (typeof window === "undefined") return
  sessionStorage.removeItem(CSRF_TOKEN_NAME)
}
