import { z } from "zod"

export const stateSchema = z.object({
  name: z
    .string()
    .min(2, "State name must be at least 2 characters")
    .max(100, "State name is too long")
    .regex(/^[a-zA-Z\s]+$/, "State name can only contain letters and spaces"),
})

export const citySchema = z.object({
  stateId: z.string().min(1, "Please select a state"),
  name: z
    .string()
    .min(2, "City name must be at least 2 characters")
    .max(100, "City name is too long")
    .regex(/^[a-zA-Z\s]+$/, "City name can only contain letters and spaces"),
})

export type StateInput = z.infer<typeof stateSchema>
export type CityInput = z.infer<typeof citySchema>
